/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm2216;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.GraphicAction;
import ibm.nways.jdm.GraphicActionNavigate;
import ibm.nways.jdm.GraphicComponent;
import ibm.nways.jdm.GraphicContainer;
import ibm.nways.jdm.GraphicFlyOver;
import ibm.nways.jdm.GraphicHandler;
import ibm.nways.jdm.GraphicHelp;
import ibm.nways.jdm.GraphicImage;
import ibm.nways.jdm.GraphicPanel;
import ibm.nways.jdm.HelpRef;
import ibm.nways.jdm.Icon;
import ibm.nways.jdm.JdmBrowser;
import ibm.nways.jdm.JdmLayout;
import ibm.nways.jdm.NavInitialRow;
import ibm.nways.jdm.NavigationContext;
import ibm.nways.jdm.NavigationDestination;
import ibm.nways.jdm.RemoteModel;
import ibm.nways.jdm.RemoteStatus;
import ibm.nways.jdm.StatusProxy;
import ibm.nways.jdm.common.Gauge;
import ibm.nways.jdm.common.ModelInfo;
import ibm.nways.jdm.modelgen.GenModel;
import ibm.nways.jdm2216.ConfirmationBox;
import ibm.nways.jdm2216.DeviceGraphicInfo;
import ibm.nways.jdm2216.Fast2216Model;
import ibm.nways.jdm2216.GraphicSlotContainer;
import ibm.nways.jdm2216.StatusPipe2216Impl;
import ibm.nways.ras.RAS;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import java.util.Vector;
import netscape.security.PrivilegeManager;

public class BoxGraphic {
    private static final int RASID = 19;
    private static final int RASSUB = 16;
    private GenModel systemModel;
    private GenModel interfaceModel;
    private JdmBrowser jdm2216Browser;
    private GraphicSlotContainer slotContainer;
    private static ResourceBundle jdm2216Bundle = null;
    private Thread getSlots;
    private Thread reCheckStatus;
    private static final String PropertiesFile = "properties/jdm2216.txt";
    private static final String layoutKey = "box.layout.scheme";
    private static final String fractKey = "box.layout.fractions";
    private ModelInfo pciAdapInfo;
    private Icon statusIcon;
    GenModel jdm2216model;
    private int[] slotTypes;
    Hashtable statusIndexes;

    protected BoxGraphic(JdmBrowser jdmBrowser) {
        this.jdm2216Browser = jdmBrowser;
    }

    protected GraphicPanel getGraphicPanel() {
        StringTokenizer stringTokenizer;
        String string;
        Properties properties;
        Serializable serializable;
        GraphicContainer graphicContainer = new GraphicContainer();
        String string2 = "getGraphicPanel";
        try {
            serializable = new URL(this.jdm2216Browser.getDocumentBase(), PropertiesFile);
            properties = new Properties();
            properties.load(((URL)serializable).openStream());
        }
        catch (Exception exception) {
            RAS.logError(19, 16, this, string2, "EXCEPTION_GETTING_PROPERTIES", (Object)PropertiesFile);
            RAS.logException(19, 16, this, string2, exception);
            properties = null;
        }
        JdmLayout jdmLayout = (JdmLayout)this.jdm2216Browser.getLayout();
        this.slotTypes = null;
        if (properties != null) {
            serializable = new Integer((String)((Hashtable)properties).get(layoutKey));
            int n = (Integer)serializable;
            jdmLayout.setScheme(n);
            string = (String)((Hashtable)properties).get(fractKey);
            stringTokenizer = new StringTokenizer(string);
            float[] fArray = new float[stringTokenizer.countTokens()];
            boolean bl = true;
            int n2 = 0;
            while (n2 < fArray.length && stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                try {
                    fArray[n2] = Float.valueOf(string3).floatValue();
                }
                catch (NumberFormatException numberFormatException) {
                    RAS.logException(19, 16, this, string2, (Exception)numberFormatException);
                    if (RAS.isEnabled(19, 16)) {
                        RAS.trace(19, 16, this, string2, "Bad layout.fractions parm(" + numberFormatException.getMessage() + ")");
                    }
                    bl = false;
                }
                ++n2;
            }
            if (bl) {
                jdmLayout.setFracts(fArray);
            }
        }
        if (jdm2216Bundle == null) {
            jdm2216Bundle = ResourceBundle.getBundle("ibm.nways.jdm2216.Resources");
        }
        serializable = new Point(20, 20);
        string = null;
        try {
            this.systemModel = (GenModel)this.jdm2216model.getComponent("System");
            string = new GraphicActionNavigate((GraphicHandler)this.jdm2216Browser, new NavigationDestination("ibm.nways.mib2.eui.SystemPanel", (RemoteModel)this.systemModel), null);
        }
        catch (Exception exception) {
            RAS.logException(19, 16, this, string2, exception);
        }
        GraphicImage graphicImage = new GraphicImage(this.jdm2216Browser.imageFrom((Object)this, "jdm2216.gif"), (Point)serializable, 3, (GraphicAction)string, null);
        graphicContainer.add((GraphicComponent)graphicImage);
        stringTokenizer = new GraphicHelp((BrowserApplet)this.jdm2216Browser, new Point(0, 0), new HelpRef((Object)this));
        graphicContainer.add((GraphicComponent)stringTokenizer);
        this.slotContainer = new GraphicSlotContainer(this.jdm2216Browser, (Point)serializable);
        this.doGraphicsThread();
        graphicContainer.add((Component)((Object)this.slotContainer), 0);
        GraphicPanel graphicPanel = new GraphicPanel((GraphicHandler)this.jdm2216Browser, (Component)graphicContainer);
        return graphicPanel;
    }

    public void doGraphicsThread() {
        String string = "doGraphicsThread";
        if (this.getSlots != null) {
            this.getSlots.stop();
        }
        this.statusIndexes = new Hashtable(30);
        GenModel genModel = null;
        try {
            genModel = (GenModel)this.jdm2216model.getComponent("Ibm2216Graphic");
        }
        catch (Exception exception) {}
        if (RAS.isEnabled(19, 16)) {
            RAS.trace(19, 16, this, string, "ibm2216GraphicModel = " + genModel);
        }
        this.getSlots = new GraphicsThread(genModel);
        this.getSlots.start();
    }

    private int[] getSlotTypes() {
        return this.slotTypes;
    }

    public void showSlotContainer() {
        if (this.slotContainer != null) {
            this.slotContainer.showCards();
        }
    }

    public void stopThreads() {
        if (this.getSlots != null && this.getSlots.isAlive()) {
            this.getSlots.stop();
        }
        if (this.reCheckStatus != null && this.reCheckStatus.isAlive()) {
            this.reCheckStatus.stop();
        }
        if (this.statusIcon != null) {
            this.jdm2216Browser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
        }
    }

    void predetermineAllSlots() {
        String string = "predetermineAllSlots";
        if (this.pciAdapInfo == null) {
            return;
        }
        try {
            int n;
            int n2 = 0;
            this.slotTypes = new int[8];
            int n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType1");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType2");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType3");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType4");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType5");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType6");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType7");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            n3 = (Integer)this.pciAdapInfo.get("PciAdapGraphics.Ibm2216PCIAdapType8");
            this.slotTypes[n2] = n = this.mapPciSlotType(n3, n2);
            this.slotContainer.addSlot(++n2, n);
            this.showSlotContainer();
            return;
        }
        catch (Exception exception) {
            RAS.logError(19, 16, this, string, "EXCEPTION_GETTING_MODELINFO", (Object)"Ibm2216PCIAdapter", (Object)"Jdm2216Model");
            RAS.logException(19, 16, this, string, exception);
            return;
        }
    }

    public void gotOne(DeviceGraphicInfo deviceGraphicInfo) {
        Integer n = new Integer(deviceGraphicInfo.index);
        this.statusIndexes.put(n, n);
        StatusAttachThread statusAttachThread = new StatusAttachThread(deviceGraphicInfo);
        statusAttachThread.start();
    }

    public void processOne(DeviceGraphicInfo deviceGraphicInfo) {
        StatusProxy statusProxy = new StatusProxy(deviceGraphicInfo.status);
        GraphicActionNavigate graphicActionNavigate = this.createGraphicAction(deviceGraphicInfo.index);
        int n = this.mapInterfaceSlotType(deviceGraphicInfo.type, deviceGraphicInfo.speed);
        this.slotContainer.addSlot(deviceGraphicInfo.slot, deviceGraphicInfo.port, statusProxy, graphicActionNavigate, n);
    }

    private GraphicActionNavigate createGraphicAction(int n) {
        String string = "createGraphicAction";
        try {
            if (this.interfaceModel == null) {
                this.interfaceModel = (GenModel)this.jdm2216model.getComponent("Interface");
            }
            ModelInfo modelInfo = new ModelInfo();
            modelInfo.add("Index.IfIndex", new Integer(n));
            NavigationContext navigationContext = new NavigationContext();
            NavInitialRow.setInitialRow((NavigationContext)navigationContext, (ModelInfo)modelInfo);
            navigationContext.setParent(this.jdm2216Browser.getNavigationTree().getNavContext());
            GraphicActionNavigate graphicActionNavigate = new GraphicActionNavigate((GraphicHandler)this.jdm2216Browser, new NavigationDestination("ibm.nways.mib2.eui.Mib2InterfacesPanel", (RemoteModel)this.interfaceModel), navigationContext);
            return graphicActionNavigate;
        }
        catch (Exception exception) {
            RAS.logException(19, 16, this, string, exception);
            return null;
        }
    }

    private void attachStatusAndAction(GenModel genModel) {
        this.statusIcon = new Icon(this.jdm2216Browser.imageFrom((Object)this, "statusAnimation.gif"));
        this.statusIcon.setFlyOver(new GraphicFlyOver(jdm2216Bundle.getString("RetrievingStatus")));
        this.jdm2216Browser.addTrayIcon(this.statusIcon);
        try {
            Vector vector = genModel.getRestOfInfo("Panel", "default", null, null);
            int n = 0;
            while (n < vector.size()) {
                ModelInfo modelInfo = (ModelInfo)vector.elementAt(n);
                this.ibm2216GraphicAttach(modelInfo);
                ++n;
            }
        }
        catch (Exception exception) {
            this.jdm2216Browser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
            this.handleGraphicsError(exception);
            return;
        }
        this.jdm2216Browser.removeTrayIcon(this.statusIcon);
        this.statusIcon.getImage().flush();
        this.statusIcon = null;
    }

    private void ibm2216GraphicAttach(ModelInfo modelInfo) {
        try {
            int n = (Integer)modelInfo.get("Index.Ibm2216GraphicSlotNum");
            int n2 = (Integer)modelInfo.get("Index.Ibm2216GraphicPortNum");
            int n3 = (Integer)modelInfo.get("Panel.Ibm2216GraphicifIndex");
            GraphicActionNavigate graphicActionNavigate = this.createGraphicAction(n3);
            ModelInfo modelInfo2 = new ModelInfo();
            modelInfo2.add("Index.IfIndex", new Integer(n3));
            RemoteStatus remoteStatus = this.interfaceModel.getStatusRefForRow(modelInfo2);
            StatusProxy statusProxy = new StatusProxy(remoteStatus);
            this.slotContainer.addSlot(n, n2, statusProxy, graphicActionNavigate, this.slotTypes[n - 1]);
            return;
        }
        catch (Exception exception) {
            this.jdm2216Browser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
            this.handleGraphicsError(exception);
            return;
        }
    }

    private void handleGraphicsError(Exception exception) {
        String string = "handleGraphicsError";
        RAS.logException(19, 16, this, string, exception);
        1 var3_3 = new 1();
        ConfirmationBox confirmationBox = new ConfirmationBox(this.jdm2216Browser.getFrame(), jdm2216Bundle.getString("ConfimationBox Title"), jdm2216Bundle.getString("GraphicError"), var3_3);
        confirmationBox.show();
    }

    void determineAllSlots() {
        new Vector();
        this.statusIcon = new Icon(this.jdm2216Browser.imageFrom((Object)this, "statusAnimation.gif"));
        this.statusIcon.setFlyOver(new GraphicFlyOver(jdm2216Bundle.getString("RetrievingStatus")));
        this.jdm2216Browser.addTrayIcon(this.statusIcon);
        try {
            this.interfaceModel = (GenModel)this.jdm2216model.getComponent("Interface");
            StatusPipe2216Impl statusPipe2216Impl = new StatusPipe2216Impl(this);
            Fast2216Model fast2216Model = (Fast2216Model)this.jdm2216model.getComponent("HandCodedFast2216");
            Integer n = fast2216Model.getDeviceGraphicInfo(statusPipe2216Impl);
            statusPipe2216Impl.dispose();
            if (n.intValue() != this.statusIndexes.size()) {
                throw new RemoteException();
            }
            this.showSlotContainer();
        }
        catch (Exception exception) {
            this.jdm2216Browser.removeTrayIcon(this.statusIcon);
            this.statusIcon.getImage().flush();
            this.statusIcon = null;
            this.handleGraphicsError(exception);
        }
        this.jdm2216Browser.removeTrayIcon(this.statusIcon);
        this.statusIcon.getImage().flush();
        this.statusIcon = null;
    }

    protected Thread getReCheckStatusThread() {
        return this.reCheckStatus;
    }

    protected void setReCheckStatusThread(Thread thread) {
        this.reCheckStatus = thread;
    }

    int mapInterfaceSlotType(int n, long l) {
        int n2 = 0;
        switch (n) {
            case 37: {
                n2 = 10;
                break;
            }
            case 18: {
                if (l == 1544000L) {
                    n2 = 4;
                    break;
                }
                n2 = 5;
                break;
            }
            case 9: {
                if (l > 100000000L) {
                    n2 = 19;
                    break;
                }
                n2 = 3;
                break;
            }
            case 6: {
                n2 = 2;
                break;
            }
            case 64: {
                n2 = 6;
                break;
            }
            case 33: {
                n2 = 7;
                break;
            }
            case 45: 
            case 65: {
                n2 = 8;
                break;
            }
            case 73: {
                n2 = 11;
                break;
            }
            case 15: {
                n2 = 12;
                break;
            }
            case 46: {
                n2 = 14;
                break;
            }
            case 62: {
                n2 = 15;
                break;
            }
            default: {
                n2 = 0;
            }
        }
        return n2;
    }

    int mapPciSlotType(int n, int n2) {
        String string = "mapPciSlotType";
        if (RAS.isEnabled(19, 16)) {
            RAS.trace(19, 16, this, string, "pciType: " + n + " ,slot: " + n2);
        }
        int n3 = 0;
        switch (n) {
            case 2: {
                n3 = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                if (RAS.isEnabled(19, 16)) {
                    RAS.trace(19, 16, this, string, "*** switch(pciType) ATM: " + n);
                }
                n3 = 10;
                try {
                    if (this.interfaceModel == null) {
                        this.interfaceModel = (GenModel)this.jdm2216model.getComponent("Interface");
                    }
                    GenModel genModel = (GenModel)this.jdm2216model.getComponent("Ibm2216Graphic");
                    ModelInfo modelInfo = new ModelInfo();
                    modelInfo.add("Index.Ibm2216GraphicSlotNum", new Integer(n2 + 1));
                    modelInfo.add("Index.Ibm2216GraphicPortNum", new Integer(0));
                    ModelInfo modelInfo2 = genModel.getNextInfo("Panel", "default", modelInfo);
                    if (RAS.isEnabled(19, 16)) {
                        RAS.trace(19, 16, this, string, "*** ModelInfo graphicInfo ");
                    }
                    if (modelInfo2 == null) {
                        if (!RAS.isEnabled(19, 16)) break;
                        RAS.trace(19, 16, this, string, "*** graphicInfo==null");
                        break;
                    }
                    Integer n4 = (Integer)modelInfo2.get("Panel.Ibm2216GraphicifIndex");
                    modelInfo = new ModelInfo();
                    modelInfo.add("Index.IfIndex", n4);
                    ModelInfo modelInfo3 = this.interfaceModel.getInfo("Panel", "default", modelInfo);
                    Integer n5 = (Integer)modelInfo3.get("Panel.IfType");
                    Gauge gauge = (Gauge)modelInfo3.get("Panel.IfSpeed");
                    if (n5 == 9 && gauge.getValue() > 100000000L) {
                        n3 = 19;
                    }
                    if (!RAS.isEnabled(19, 16)) break;
                    RAS.trace(19, 16, this, string, "*** ifIndex,ifType,ifSpeed,retval= " + n4 + "," + n5 + "," + gauge + "," + n3);
                }
                catch (Exception exception) {
                    RAS.logException(19, 16, this, string, exception);
                }
                break;
            }
            case 9: {
                n3 = 4;
                break;
            }
            case 10: {
                n3 = 5;
                break;
            }
            case 18: {
                n3 = 17;
                break;
            }
            case 19: {
                n3 = 18;
                break;
            }
            case 7: {
                n3 = 3;
                break;
            }
            case 14: {
                n3 = 2;
                break;
            }
            case 13: {
                n3 = 6;
                break;
            }
            case 11: {
                n3 = 7;
                break;
            }
            case 12: {
                n3 = 8;
                break;
            }
            case 8: {
                n3 = 11;
                break;
            }
            case 20: {
                n3 = 16;
                break;
            }
            case 17: {
                n3 = 12;
                break;
            }
            case 16: {
                n3 = 14;
                break;
            }
            case 15: {
                n3 = 15;
                break;
            }
            default: {
                n3 = 0;
            }
        }
        return n3;
    }

    protected void setJdm2216Model(GenModel genModel) {
        this.jdm2216model = genModel;
    }

    protected void setPciAdapInfo(ModelInfo modelInfo) {
        this.pciAdapInfo = modelInfo;
    }

    class GraphicsThread
    extends Thread {
        GenModel ibm2216GraphicModel;
        private final int RASID = 19;
        private final int RASSUB = 16;

        public GraphicsThread(GenModel genModel) {
            BoxGraphic.this = BoxGraphic.this;
            this.ibm2216GraphicModel = genModel;
        }

        public void run() {
            if (BoxGraphic.this.jdm2216Browser != null && BoxGraphic.this.jdm2216Browser.isNetscape()) {
                PrivilegeManager.enablePrivilege((String)"UniversalConnect");
            }
            this.setPriority(this.getPriority() + 1);
            BoxGraphic.this.predetermineAllSlots();
            if (this.ibm2216GraphicModel == null || BoxGraphic.this.getSlotTypes() == null) {
                BoxGraphic.this.determineAllSlots();
                return;
            }
            BoxGraphic.this.attachStatusAndAction(this.ibm2216GraphicModel);
        }
    }

    class StatusAttachThread
    extends Thread {
        DeviceGraphicInfo devInfo;

        public StatusAttachThread(DeviceGraphicInfo deviceGraphicInfo) {
            BoxGraphic.this = BoxGraphic.this;
            this.devInfo = deviceGraphicInfo;
        }

        public void run() {
            BoxGraphic.this.processOne(this.devInfo);
        }
    }

    private final class 1
    implements ActionListener {
        public void actionPerformed(ActionEvent actionEvent) {
            BoxGraphic.this.doGraphicsThread();
        }

        /* synthetic */ 1() {
        }
    }
}

